<?php

namespace app\modules\setup\models;

use Yii;

/**
 * This is the model class for table "{{%profile}}".
 *
 * @property int $user_id
 * @property string $name
 * @property string $timezone
 * @property string $language
 * @property string $public_email
 * @property string $gravatar_email
 * @property string $gravatar_id
 * @property string $location
 * @property string $website
 * @property string $bio
 *
 * @property Account $account
 */
class Profile extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%profile}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['user_id'], 'required'],
            [['user_id'], 'integer'],
            [['bio'], 'string'],
            [['name', 'timezone', 'language', 'public_email', 'gravatar_email', 'location', 'website'], 'string', 'max' => 255],
            [['gravatar_id'], 'string', 'max' => 32],
            [['user_id'], 'unique'],
            [['user_id'], 'exist', 'skipOnError' => true, 'targetClass' => Account::className(), 'targetAttribute' => ['user_id' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'user_id' => Yii::t('setup', 'User ID'),
            'name' => Yii::t('setup', 'Name'),
            'timezone' => Yii::t('setup', 'Timezone'),
            'language' => Yii::t('setup', 'Language'),
            'public_email' => Yii::t('setup', 'Public Email'),
            'gravatar_email' => Yii::t('setup', 'Gravatar Email'),
            'gravatar_id' => Yii::t('setup', 'Gravatar ID'),
            'location' => Yii::t('setup', 'Location'),
            'website' => Yii::t('setup', 'Website'),
            'bio' => Yii::t('setup', 'Bio'),
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getAccount()
    {
        return $this->hasOne(Account::className(), ['id' => 'user_id']);
    }
}
